.\" This manpage is copyright (C) 2000 Progeny Linux Systems, Inc.
.\" Author: Branden Robinson <branden@progeny.com>
.\"
.\" This is free software; you may redistribute it and/or modify
.\" it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2,
.\" or (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the Debian GNU/Linux system; if not, write to the Free
.\" Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
.\" 02111-1307 USA
.\"
.\" That's right, although mdetect itself is under the QPL, this manpage is
.\" under the GPL.  Enjoy!
.TH mdetect 1 "2002-02-22" "Debian GNU/Linux"
.SH NAME
mdetect \- mouse device autodetection tool
.SH SYNOPSIS
mdetect [\fIoption ...\fP]
.SH OPTIONS
mdetect may be run without arguments.
.TP
.B -h
display a help message and exit
.TP
.B -n
do not search for PnP (Plug 'n' Play) mice
.TP
.B -r
[not yet implemented]
.TP
.B -v
be verbose; this option may be specified multiple times for increasing
levels of verbosity
.TP
.B -o
produce output appropriate for XFree86 3.x configuration
.TP
.B -x
produce output appropriate for XFree86 4.x configuration
.SH DESCRIPTION
.B mdetect
is a tool for autoconfiguring mice and compatible pointing devices; it is
typically used as the backend to some user-friendly frontend code that, for
example, asks the user to move the mouse for a moment.
.B mdetect
is then run while user is producing input on the mouse device.  While mouse
motion during detection is sometimes unnecessary, it is seldom problematic.
.PP
.B mdetect
writes the autodetected mouse device and protocol to standard output.
Unless either of the
.B -o
or
.B -x
options is given,
.B mdetect
produces output appropriate for configuring the
.BR gpm (1)
program.  Alternatively, output appropriate for an XFree86 X server
configuration file is produced.  If the
.B -v
option is given, some information about the program's status is also
written to standard output, but this is largely unimplemented at this
writing.
.PP
If
.B mdetect
is unable to find a mouse device, it exits after a few seconds of
searching.
.SH NOTES
Detection of serial and PS/2 devices is often aided by moving the mouse while
.B mdetect
runs.
.PP
Terminals connected to serial ports may display a small amount of garbage
to the screen while
.B mdetect
probes them, but this a harmless side-effect; the terminal's line settings
are restored after the port has been probed.
.SH DIAGNOSTICS
.BR mdetect 's
exit status is used to communicate information.
.IP 0
.B mdetect
found a mouse and exited normally.
.IP 1
An error occurred while attempting to read from the mouse device.
.IP 2
.B mdetect
timed out and gave up searching for a mouse device; this indicates either
that no mouse device is attached to the computer, or that a mouse device
exists which
.B mdetect
knows nothing about.  This also happens if your only mouse device(s) are
already open and in use; for instance, by
.B gpm
or an X Window System server.
.IP 3
An error occurred while trying to set up
.BR mdetect 's
signal handler.
.SH BUGS
Please report bugs in
.B mdetect
to <submit@bugs.debian.org>.  The current bug list may be viewed at
<http://bugs.debian.org/mdetect>.
.SH AUTHORS
.B mdetect
is copyright 1999 Caldera Systems, Inc.  The actual authors are unknown.
Branden Robinson of Progeny Linux Systems, Inc. and the Debian Project
added several enhancements, including the XFree86-aware code and this
manual page.  Richard Hirst wrote code to save and restore serial port
settings.
.SH LICENSING
The
.B mdetect
source code is licensed under the Q Public License (QPL); see
<http://www.trolltech.com/products/download/freelicense/license.html>.
.PP
This manual page is licensed under the GNU General Public License.
.SH SEE ALSO
.IR gpm (1),
.IR XFree86 (1)
